package gov.va.med.mhv.integration.phr.stage.transfer;

import java.util.Date;

/**
 * StageReminder entity.
 * 
 */

public class StageImmunization extends StageEntity {

	// Fields
	private String immunizationName;
	private String reaction;
	private String comments;
	private String locationName;
	private Date eventTime;
	private String eventTimeImprecise;
	
	// Constructors

	/**
	 * default constructor do not provide auto initialization since this class
	 * can be used in findByExample
	 */
	public StageImmunization() {
		super();
	}

	// Property accessors

	public String getComments() {
		return comments;
	}

	public void setComments(String comments) {
		this.comments = doubleUnescapeHtml(comments);
	}

	public Date getEventTime(){
    return eventTime;
	}
	
	public void setEventTime(Date eventTime) {
		this.eventTime = eventTime;
	}
   
	public String getEventTimeImprecise() {
		return eventTimeImprecise;
	}

	public void setEventTimeImprecise(String eventTimeImprecise) {
		this.eventTimeImprecise = eventTimeImprecise;
	}

	public String getImmunizationName() {
		return immunizationName;
	}

	public void setImmunizationName(String ImmunizationName) {
		this.immunizationName = doubleUnescapeHtml(ImmunizationName);
	}

	public String getLocationName() {
		return locationName;
	}

	public void setLocationName(String locationName) {
		this.locationName = doubleUnescapeHtml(locationName);
	}

	public String getReaction() {
		return reaction;
	}

	public void setReaction(String reaction) {
		this.reaction = doubleUnescapeHtml(reaction);
	}

	public String toString() {
		return  "StageImmunization {" + 
				", id=" + getId() + 
				", oplock=" + oplock +
				", createdDate=" + createdDate + 
				", modifiedDate=" + modifiedDate + 
				", icn='" + icn + '\'' +
				", stationNumber='"	+ stationNumber + '\'' + 
				", requestMsgCtrlId=" + requestMsgCtrlId + 
				", responseMsgCtrlId=" + responseMsgCtrlId + 
				", extractStatus='" + extractStatus + '\'' + 
				", recordStatus='" + recordStatus + '\'' + 
				", ImmunizationName='" + immunizationName	+ 
				", Comments='" + comments + '\'' +
				", LocationName='" + locationName + '\'' +
				", eventTime='" + eventTime + '\'' +
				", eventTimeImprecise='" + eventTimeImprecise + '\'' +
				'}';
	}

	@Override
	public boolean equals(Object obj) {
		boolean result = false;
		result = String.valueOf(obj).equalsIgnoreCase(String.valueOf(this));
		return result;
	}

	public void setAK(StageEntityAK ak) {
		this.icn = ak.getIcn();
		// Station number is excluded because it comes from the response not the
		// request
		// in the case of immunization.

		// this.stationNumber=ak.getStationNumber();
		this.requestMsgCtrlId = ak.getRequestMsgCtrlId();
		this.responseMsgCtrlId = ak.getResponseMsgCtrlId();
	}

	public String toCompare() {
		return "" + getComments() +
				getEventTime() +
				getEventTimeImprecise() +
				getImmunizationName() +
				getLocationName() +
				getReaction();
	}

}
